// Qui ci sono delle funzioni di appoggio.

#include <func2.h>

// Questa funzione prende un valore frazionario, compreso tra le tensioni
// minima e massima del DAC del DSP, e restituisce il corretto intero che lo
// rappresenta nel DSP. Se il valore esce dal campo ammesso, il risultato
// e' "cimato".

int toNumDac (double valore)
{
int risultato = 0 ;
// Se il valore supera il massimo, lo imposto uguale al massimo
if (valore > Vmax)
    valore = Vmax ;

// Se il valore e' sotto il minimo, lo imposto uguale al minimo
if (valore < Vmin)
   valore = Vmin ;

// Se il valore e' positivo...
if (valore > 0) {

risultato = (int) (valore / Vmax * 8191) ;

}// ramo if
// Se invece e' negativo...
else  {

risultato = (int) (16384 + (valore / -Vmin * 8192)) ;

}// ramo else

return (risultato) ;
}// end toNumDac
